/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.effects.particles;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.particles.AgeableMote;
import org.orecruncher.mobeffects.footsteps.FootprintStyle;

@OnlyIn(value=Dist.CLIENT)
public class FootprintMote
extends AgeableMote {
    private static final float TEXEL_WIDTH = 0.125f;
    private static final float TEXEL_PRINT_WIDTH = 0.0625f;
    private static final float WIDTH = 0.125f;
    private static final float LENGTH = 0.25f;
    private static final Vector2f FIRST_POINT = new Vector2f(-0.125f, 0.25f);
    private static final Vector2f SECOND_POINT = new Vector2f(0.125f, 0.25f);
    private static final Vector2f THIRD_POINT = new Vector2f(0.125f, -0.25f);
    private static final Vector2f FOURTH_POINT = new Vector2f(-0.125f, -0.25f);
    private static float zFighter = 0.0f;
    protected final boolean isSnowLayer;
    protected final BlockPos downPos;
    protected final float texU1;
    protected final float texU2;
    protected final float texV1;
    protected final float texV2;
    protected final float scale;
    protected final Vector2f firstPoint;
    protected final Vector2f secondPoint;
    protected final Vector2f thirdPoint;
    protected final Vector2f fourthPoint;

    public FootprintMote(@Nonnull FootprintStyle style, @Nonnull IBlockReader world, double x, double y, double z, float rotation, float scale, boolean isRight) {
        super(world, x, y, z);
        BlockState state;
        float f;
        this.maxAge = 200;
        zFighter += 1.0f;
        if (f > 20.0f) {
            zFighter = 1.0f;
        }
        this.isSnowLayer = (state = world.func_180495_p((BlockPos)this.position)).func_177230_c() == Blocks.field_150433_aE;
        this.posY += (double)(zFighter * 0.001f);
        float fraction = (float)(y - (double)((int)y));
        this.downPos = this.isSnowLayer || fraction <= 0.0625f ? new BlockPos(this.posX, this.posY, this.posZ).func_177977_b() : this.position.func_185334_h();
        float u1 = (float)style.ordinal() * 0.125f + 0.00390625f;
        if (isRight) {
            u1 += 0.0625f;
        }
        this.texU1 = u1;
        this.texU2 = u1 + 0.0625f;
        this.texV1 = 0.0f;
        this.texV2 = 1.0f;
        this.scale = scale;
        float theRotation = MathStuff.toRadians(-rotation + 180.0f);
        this.firstPoint = MathStuff.rotateScale(FIRST_POINT, theRotation, this.scale);
        this.secondPoint = MathStuff.rotateScale(SECOND_POINT, theRotation, this.scale);
        this.thirdPoint = MathStuff.rotateScale(THIRD_POINT, theRotation, this.scale);
        this.fourthPoint = MathStuff.rotateScale(FOURTH_POINT, theRotation, this.scale);
    }

    @Override
    protected boolean advanceAge() {
        if (this.world instanceof World && ((World)this.world).func_72896_J()) {
            this.age = (int)((float)this.age + WorldUtils.getRainStrength((World)this.world, 1.0f) * 100.0f / 25.0f);
        }
        return super.advanceAge();
    }

    @Override
    protected void update() {
        if (this.isSnowLayer && this.world.func_180495_p((BlockPos)this.position).func_177230_c() != Blocks.field_150433_aE) {
            this.kill();
        } else {
            BlockState state = this.world.func_180495_p(this.downPos);
            if (!state.func_185904_a().func_76220_a()) {
                this.kill();
            }
        }
    }

    @Override
    public void renderParticle(@Nonnull IVertexBuilder buffer, @Nonnull ActiveRenderInfo info, float partialTicks) {
        float f = ((float)this.age + partialTicks) / ((float)this.maxAge + 1.0f);
        f *= f;
        this.alpha = MathStuff.clamp1(1.0f - f) * 0.4f;
        double x = this.renderX(info, partialTicks);
        double y = this.renderY(info, partialTicks);
        double z = this.renderZ(info, partialTicks);
        this.drawVertex(buffer, x + (double)this.firstPoint.field_189982_i, y, z + (double)this.firstPoint.field_189983_j, this.texU1, this.texV2);
        this.drawVertex(buffer, x + (double)this.secondPoint.field_189982_i, y, z + (double)this.secondPoint.field_189983_j, this.texU2, this.texV2);
        this.drawVertex(buffer, x + (double)this.thirdPoint.field_189982_i, y, z + (double)this.thirdPoint.field_189983_j, this.texU2, this.texV1);
        this.drawVertex(buffer, x + (double)this.fourthPoint.field_189982_i, y, z + (double)this.fourthPoint.field_189983_j, this.texU1, this.texV1);
    }
}

